#define _WIN32_WINNT 0x0500 
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "TinySynth.h"

// Global scene positioning and timing
float g_time;

// ==================================================================
// Render procedure
void Render ( ) {
	glClearColor ( 0.1f, 0.1f, 0.2f, 1.0f );
	glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	// Setup render states and view
	glMatrixMode ( GL_MODELVIEW );
	glEnable ( GL_COLOR_MATERIAL );
	glEnable ( GL_BLEND );
	glBlendFunc ( GL_SRC_ALPHA, GL_SRC_ALPHA );
	glLoadIdentity ( );
	gluLookAt ( cosf ( g_time )*3.5f, 0, sinf ( g_time )*3.5f, 0, 0, 0, 0, 1, 0 );
	glPushMatrix ( );

	// Render points
	glBegin ( GL_LINES );
		for ( int i = 0; i < 500; i++ ) {
			glColor4f ( 0.3f*(sinf(i*0.01f)+1.1f), 0.7f, 0.4f, 0.5f );
			glVertex3f ( sinf ( g_time + i ), sinf ( g_time * 1.2f + i ), sinf ( g_time*2.1f + i*3 ) );
		}
	glEnd ( );

	// Render spheres
	glColor4f ( 0.2f, 0.3f, 0.7f, 0.9f );
	GLUquadricObj* quadObj;
	quadObj = gluNewQuadric ( ); 
	gluQuadricDrawStyle ( quadObj, GLU_FILL );
	for ( int i = 0; i < 100; i++ ) {
		glPopMatrix ( );
		glPushMatrix ( );
		glTranslatef ( sinf ( i * 0.5f )*1.2f, Sawtooth ( g_time + i )*2, cosf ( i * 0.3f )*1.2f );
		gluSphere ( quadObj, 0.05f, 6, 6 );
		gluSphere ( quadObj, 0.06f, 6, 6 );
	}
	gluDeleteQuadric ( quadObj );
	glPopMatrix ( );

	// Fade screen
	glDisable ( GL_LIGHTING );
	glColor4f ( 0, 0, 0, ( sinf ( g_time ) + 2.0f ) * 0.3f );
	glLoadIdentity ( );
	glMatrixMode ( GL_PROJECTION );
	glPushMatrix ( );
	glLoadIdentity ( );
	glDisable ( GL_CULL_FACE );
	glRectf ( -1.1f, -1.1f, 1.1f, 1.1f );
	glPopMatrix ( );
	SwapBuffers ( wglGetCurrentDC ( ) );
} // Render


// ==================================================================
// Main function
int APIENTRY WinMain (	HINSTANCE hInstance,
						HINSTANCE hPrevInstance,
						LPSTR     lpCmdLine,
						int       nCmdShow ) {
	// Create window and make some OpenGL initialization
	HWND hWnd = CreateWindow ( "EDIT", NULL, WS_POPUP | WS_VISIBLE, 0, 0, 0, 0, NULL, NULL, hInstance, NULL );
	ShowWindow ( hWnd, SW_SHOWMAXIMIZED );
	ShowCursor ( FALSE );
	HDC hdc = GetDC ( hWnd );
	PIXELFORMATDESCRIPTOR pfd = { sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,
		PFD_TYPE_RGBA, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0 };
	int pixFormat = ChoosePixelFormat ( hdc, &pfd );
	SetPixelFormat ( hdc, pixFormat, &pfd ); 
	HGLRC hglrc = wglCreateContext ( hdc );
	wglMakeCurrent ( hdc, hglrc );
	RECT r;
	GetClientRect ( hWnd, &r );

	// Initialize demo
	CreateAndPlaySynth ( );
	glMatrixMode ( GL_PROJECTION );
	glLoadIdentity ( );
	gluPerspective ( 45, (GLdouble)r.right/r.bottom, 1, 100 );

	// Main message loop
	SetThreadPriority ( GetCurrentThread ( ), THREAD_PRIORITY_ABOVE_NORMAL );
	HANDLE hTimer = CreateWaitableTimer ( 0, TRUE, NULL );
	LARGE_INTEGER due = { -200000, -1 };
	MMTIME mt = { TIME_BYTES };
	while ( !GetAsyncKeyState ( VK_ESCAPE ) ) {
		SetWaitableTimer ( hTimer, &due, 0, NULL, NULL, FALSE );
		waveOutGetPosition ( g_wo, &mt, sizeof(mt) );
		g_time = (float)mt.u.cb / (SAMPLE_FREQUENCY*sizeof(short));
		Render ( );
		if ( g_time > PLAY_TIME - 0.5f )
			break;
		WaitForSingleObject ( hTimer, INFINITE );
	}
	ExitProcess ( 0 );
} // WinMain